/*
<samplecode>
  <abstract>
  Row item view for the save picker to show each saved version.
  </abstract>
</samplecode>
*/

import SwiftUI

struct SavePickerCell: View {
    
    let saveVersion: SaveVersion
    
    let saveInformation: CloudSaveDeviceInformation?
    
    var body: some View {
        HStack {
            Image(systemName: systemImageNameBySaveVersion)
                .font(.title)
                .foregroundColor(.accentColor)
            
            LabeledContent {
                Text(localityString)
            } label: {
                Text(saveInformation?.deviceName ?? "Device Name")
                Text(saveInformation?.lastFileModification?.description ?? "Last Modification Date")
            }
        }
    }
    
    var systemImageNameBySaveVersion: String {
        switch saveVersion {
        case .cloud:
            return "cloud"
        case .local:
            return "folder"
        }
    }
    
    var localityString: String {
        let unknownLocalityString = "Locality"
        
        guard let locality = saveInformation?.locality else {
            return unknownLocalityString
        }
        
        switch locality {
        case CloudSaveLocalityLocal:
            return "Local"
        case CloudSaveLocalityServer:
            return "Remote"
        default:
            return unknownLocalityString
        }
    }
}

#Preview {
    List {
        SavePickerCell(saveVersion: .cloud, saveInformation: .init())
        SavePickerCell(saveVersion: .local, saveInformation: .init())
    }
}
